from time import time as time
import tkinter
from random import randrange as rr

R = 35
R_druhu = R**2
tlac_sirka = 175**2
tlac_vyska = 35**2

class Hra:
    level = 0
    def __init__(self):
        self.c = Button.c = Tile.c = Circle.c = Obstacle.c = Single.c = Menu.c = Multi.c = Tutorial.c = tkinter.Canvas(width=1100, height=760)
        self.c.pack()
        Menu()
        self.c.mainloop()

class Tutorial:
    def __init__(self):
        self.c.delete("all")
        self.bg = tkinter.PhotoImage(file='files/bg_tut.gif')
        self.c.create_image(0, 0, image=self.bg, anchor='nw')
        self.faza = 0
        self.sekv = (tkinter.PhotoImage(file='files/tut0.gif'), tkinter.PhotoImage(file='files/tut1.gif'))
        self.tut = self.c.create_image(550, 380, image=self.sekv[self.faza])
        self.c.create_text(553, 722, text="hint: click for more instructions!", fill="gray30", font = "arial 20")
        self.c.create_text(550, 720, text="hint: click for more instructions!", fill="white", font = "arial 20") 

        self.tlacidlo = (Button(550,380,"Back to Menu", Menu))
        self.tlacidlo.normal()

        self.c.bind('<Button-1>', self.udalost_klik)
        self.c.bind('<Motion>', self.udalost_pohyb)
        self.animacia()

    def udalost_pohyb(self, event):
        if ((self.tlacidlo.xy[0]-event.x)**2 < tlac_sirka) and ((self.tlacidlo.xy[1]-event.y)**2 < tlac_vyska):
            self.tlacidlo.hover()
        else:
            self.tlacidlo.normal()
        
    def udalost_klik(self, event):
        if ((self.tlacidlo.xy[0]-event.x)**2 < tlac_sirka) and ((self.tlacidlo.xy[1]-event.y)**2 < tlac_vyska):
            self.tlacidlo.active()
        else:
            self.animacia()

    def animacia(self):
        self.c.itemconfig(self.tut, image=self.sekv[self.faza])
        self.faza = (self.faza + 1) % len(self.sekv)


class Menu:
    def __init__(self):
        self.c.delete("all")
        self.bg = tkinter.PhotoImage(file='files/bg_menu.gif')
        self.c.create_image(0, 0, image=self.bg, anchor='nw')
        self.c.create_text(553, 88, text="Circles", fill="gray30", font = "arial 65 bold")
        self.c.create_text(550, 85, text="Circles", fill="white", font = "arial 65 bold") 
        self.c.create_text(553, 658, text="@ Lukáš Gajdošech 2017", fill="gray30", font = "arial 25")
        self.c.create_text(550, 655, text="@ Lukáš Gajdošech 2017", fill="white", font = "arial 25") 
        
        Hra.level = 0

        self.board = [[] for i in range(10)]
        for i in range(7):
            for j in range(13):
                self.board[i].append(Tile(70*j+65+65, 70*i+65+105))
                if i > 0:
                    self.board[i][j].sus.add((i-1,j))
                    self.board[i-1][j].sus.add((i, j))
                if j > 0:
                    self.board[i][j].sus.add((i, j-1))
                    self.board[i][j-1].sus.add((i, j))

        for i in range(2):
            riadok = rr(7)
            stlpec = rr(6)-2
            if stlpec > 2:
                stlpec += 7
            self.board[riadok][stlpec] = Obstacle(self.board[riadok][stlpec], self.board)

        self.oponentove = set()  
        for i in "blue", "red", "purple", "yellow", "green":
            while not self.kontrola(self.board[riadok][stlpec]):
                riadok, stlpec = rr(7), rr(13)
            self.board[riadok][stlpec] = Circle(self.board[riadok][stlpec], self.board, i, 0)
            self.oponentove.add(self.board[riadok][stlpec])
            while not self.kontrola(self.board[riadok][stlpec]):
                riadok, stlpec = rr(7), rr(13)
            self.board[riadok][stlpec] = Circle(self.board[riadok][stlpec], self.board, i, 0)

        for riadok in self.board:
            for vrchol in riadok:
                vrchol.kresli()

        self.tlacidla = set()
        self.tlacidla.add(Button(550,240,"Single Player", Single))
        self.tlacidla.add(Button(550,380,"Multi Player", Multi))
        self.tlacidla.add(Button(550,520,"Tutorial", Tutorial))
        for tlacidlo in self.tlacidla:
            tlacidlo.normal()
    
        self.c.bind('<Button-1>', self.udalost_klik)
        self.c.bind('<Motion>', self.udalost_pohyb)
        self.stop = 0
        self.c.after(200,self.oponent)

    def udalost_pohyb(self, event):
        for tlacidlo in self.tlacidla:
            x, y = tlacidlo.xy
            if ((x-event.x)**2 < tlac_sirka) and ((y-event.y)**2 < tlac_vyska):
                tlacidlo.hover()
            else:
                tlacidlo.normal()
        
    def udalost_klik(self, event):
        for tlacidlo in self.tlacidla:
            x, y = tlacidlo.xy
            if ((x-event.x)**2 < tlac_sirka) and ((y-event.y)**2 < tlac_vyska):
                self.stop = 1
                tlacidlo.active()

    def kontrola(self, vrchol):
        if type(vrchol) == Circle or type(vrchol) == Obstacle:
            return False
        for r, s in vrchol.sus:
            if type(self.board[r][s]) == Circle or type(self.board[r][s]) == Obstacle:
                return False
        return True

    def oponent(self):
        def backtracking(v1, cesta):
            if self.cesta:
                return
            if type(v1) == Circle and v1 != self.povodny:
                self.cesta = cesta
            else:
                self.visited.add(v1)
                for r, s in v1.sus:
                    v = self.board[r][s]
                    if (v not in self.visited and v.volny and len(cesta)<12) and (type(v) == Tile or v.farba == self.povodny.farba):
                        backtracking(v, cesta+[v])
                self.visited.remove(v1)                   
    
        self.cesta = []
        self.i = 0
        self.visited = set()
        self.povodny = self.oponentove.pop()
        backtracking(self.povodny, [self.povodny])
        if not self.cesta and self.oponentove:
            self.c.after(200, self.oponent)
        elif self.cesta:
            self.kresli_spojenie()
        else:
            self.c.after(200, self.__init__) 

    def kresli_spojenie(self):
        if not self.stop:
            self.cesta[self.i].volny = 0
            self.cesta[self.i+1].volny = 0
            self.c.create_line(self.cesta[self.i].xy, self.cesta[self.i+1].xy, fill=self.povodny.farba, width=10)
            if type(self.cesta[self.i]) == Circle:
                self.cesta[self.i].active()
            if type(self.cesta[self.i+1]) == Circle:
                self.cesta[self.i+1].active()
            for tlacidlo in self.tlacidla:
                if tlacidlo.normalne:
                    tlacidlo.normalne = 0
                    tlacidlo.normal()
                elif tlacidlo.hoverovane:
                    tlacidlo.hoverovane = 0
                    tlacidlo.hover()
            self.c.update()
            self.i += 1
            if self.i < len(self.cesta)-1:
                self.c.after(200, self.kresli_spojenie)
            elif self.oponentove:
                self.c.after(200, self.oponent)
            elif not self.oponentove:
                self.c.after(200, self.__init__)               

##################################################################################################################################        

class Button:
    def __init__(self, x, y, napis, funkcia):
        self.funkcia = funkcia
        self.napis = napis
        self.xy = x, y
        self.tlacidlo = None
        self.text = None
        self.aktivovane = 0
        self.normalne = 0
        self.hoverovane = 0

    def normal(self):
        if not self.aktivovane and not self.normalne:
            x, y = self.xy
            self.normalne = 1
            self.hoverovane = 0
            self.c.delete(self.tlacidlo)
            self.c.delete(self.text)
            self.img = tkinter.PhotoImage(file='files/btn.gif')
            self.tlacidlo = self.c.create_image(x, y, image=self.img)
            self.text = self.c.create_text(x, y, text=self.napis, fill="white", font = "arial 35 bold") 

    def active(self):
        x, y = self.xy
        self.aktivovane = 1
        self.c.delete(self.tlacidlo)
        self.c.delete(self.text)
        self.img = tkinter.PhotoImage(file='files/btn_active.gif')
        self.tlacidlo = self.c.create_image(x, y, image=self.img)
        self.text = self.c.create_text(x, y, text=self.napis, fill="black", font = "arial 35 bold")
        self.c.update()
        self.funkcia()
             
    def hover(self):
        if not self.aktivovane and not self.hoverovane:
            x, y = self.xy
            self.hoverovane = 1
            self.normalne = 0
            self.c.delete(self.tlacidlo)
            self.c.delete(self.text)
            self.img = tkinter.PhotoImage(file='files/btn_hover.gif')
            self.tlacidlo = self.c.create_image(x, y, image=self.img)
            self.text = self.c.create_text(x, y, text=self.napis, fill="black", font = "arial 35 bold")

class Obstacle:
    def __init__(self, tile, plocha):
        self.xy = tile.xy
        self.volny = 0
        self.id = None
        self.border = None
    def kresli(self):
        x, y = self.xy
        self.c.delete(self.id)
        self.c.delete(self.border)
        self.img = tkinter.PhotoImage(file='files/obstacle' + str(rr(2) + 1) + '.gif')
        self.id = self.c.create_image(x, y, image=self.img)
        self.border = self.c.create_rectangle(x-R, y-R, x+R, y+R, outline="grey", width=3)

class Circle:
    remain = set()
    def __init__(self, tile, plocha, farba, pridaj=1):
        self.xy = tile.xy
        self.sus = tile.sus
        self.farba = farba
        self.volny = 1
        self.id = None
        self.border = None
        self.tile = None
        if pridaj:
            Circle.remain.add(self)
        
    def kresli(self):
        x, y = self.xy
        self.c.delete(self.id)
        self.c.delete(self.border)
        self.c.delete(self.tile)
        self.tile_img = tkinter.PhotoImage(file='files/tile1.gif')
        self.tile = self.c.create_image(x, y, image=self.tile_img)
        self.border = self.c.create_rectangle(x-R, y-R, x+R, y+R, outline="grey", width=3)
        self.img = tkinter.PhotoImage(file='files/' + self.farba + '.gif')
        self.id = self.c.create_image(x, y, image=self.img)

    def active(self):
        x, y = self.xy
        self.c.delete(self.id)
        self.img = tkinter.PhotoImage(file='files/' + self.farba + '_active.gif')
        self.id = self.c.create_image(x, y, image=self.img)
        
class Tile:
    def __init__(self, x, y):
        self.sus = set()
        self.xy = x, y
        self.volny = 1
        self.id = None
        self.border = None

    def kresli(self):
        x, y = self.xy
        self.c.delete(self.id)
        self.c.delete(self.border)
        self.img = tkinter.PhotoImage(file='files/tile' + str(rr(4)+1) + '.gif')
        self.id = self.c.create_image(x, y, image=self.img)
        self.border = self.c.create_rectangle(x-R, y-R, x+R, y+R, outline="grey", width=3)

##################################################################################################################################

class Multi:
    def __init__(self):
        self.c.delete("all")
        Circle.remain = set()
        self.bg = tkinter.PhotoImage(file='files/bg.gif')
        self.c.create_image(0, 0, image=self.bg, anchor='nw')

        self.tlacidla = set()
        self.tlacidla.add(Button(915,695,"Back to Menu", Menu))
        self.tlacidla.add(Button(915,555,"Reset Level", Multi))
        self.tlacidla.add(Button(915,415,"Surrender", self.surrender))
        for tlacidlo in self.tlacidla:
            tlacidlo.normal()

        self.pocet_tahov = 0
        self.max = 8
        self.img = tkinter.PhotoImage(file='files/btn_hover.gif')
        self.c.create_image(915, 275, image=self.img)
        self.tahy_vypis = self.c.create_text(915, 275, text="Moves: " + str(self.max), fill="black", font = "arial 35 bold") 

        self.board = [[] for i in range(10)]
        for i in range(10):
            for j in range(10):
                self.board[i].append(Tile(70*j+65, 70*i+65))
                if i > 0:
                    self.board[i][j].sus.add((i-1,j))
                    self.board[i-1][j].sus.add((i, j))
                if j > 0:
                    self.board[i][j].sus.add((i, j-1))
                    self.board[i][j-1].sus.add((i, j))

        for i in range(2):
            riadok = rr(5) + 3
            stlpec = rr(10)
            self.board[riadok][stlpec] = Obstacle(self.board[riadok][stlpec], self.board)

        self.oponentove = set()    
        for i in range(10):
            if i%2:
                self.board[9][i] = Circle(self.board[9][i], self.board, "red", 0)
                self.oponentove.add(self.board[9][i])
            else:
                self.board[9][i] = Circle(self.board[9][i], self.board, "blue")
            
            while True:
                riadok = rr(4)
                stlpec = rr(10)
                if self.kontrola(self.board[riadok][stlpec]):
                    break
            if i%2:                
                self.board[riadok][stlpec] = Circle(self.board[riadok][stlpec], self.board, "red", 0)
            else:
                self.board[riadok][stlpec] = Circle(self.board[riadok][stlpec], self.board, "blue")

        for riadok in self.board:
            for vrchol in riadok:
                vrchol.kresli()

        self.cesta = []
        self.ciary = []
        self.active = None
        self.stop = 0
        self.c.bind('<Button-1>', self.udalost_klik)
        self.c.bind('<B1-Motion>', self.udalost_tahanie)
        self.c.bind('<ButtonRelease-1>', self.udalost_koniec)
        self.c.bind('<Motion>', self.udalost_pohyb)
        

    def kontrola(self, vrchol):
        if type(vrchol) == Circle or type(vrchol) == Obstacle:
            return False
        for r, s in vrchol.sus:
            if type(self.board[r][s]) == Circle or type(self.board[r][s]) == Obstacle:
                return False
        return True
                            
    def spojenie(self, v1, v2, farba):
        self.cesta.append(v1)
        self.ciary.append(self.c.create_line(v1.xy, v2.xy, fill=farba, width=10))

    def tah(self, posun):
        self.pocet_tahov += posun
        if self.max - self.pocet_tahov == 0:
            self.c.itemconfig(self.tahy_vypis, text="Moves: 0", fill="red")
        else:
            self.c.itemconfig(self.tahy_vypis, text="Moves: " + str(self.max - self.pocet_tahov), fill="black")

    def udalost_pohyb(self, event):
        for tlacidlo in self.tlacidla:
            x, y = tlacidlo.xy
            if ((x-event.x)**2 < tlac_sirka) and ((y-event.y)**2 < tlac_vyska):
                tlacidlo.hover()
            else:
                tlacidlo.normal()

    def udalost_klik(self, event):
        for tlacidlo in self.tlacidla:
            x, y = tlacidlo.xy
            if ((x-event.x)**2 < tlac_sirka) and ((y-event.y)**2 < tlac_vyska):
                tlacidlo.active()
        for riadok in self.board:
            for vrchol in riadok:
                if type(vrchol) is Circle and vrchol.volny and vrchol.farba == "blue" and vrchol.xy[1] == 695 and not self.stop:
                    x, y = vrchol.xy
                    if ((x-event.x)**2 < R_druhu) and ((y-event.y)**2 < R_druhu):
                        self.active = vrchol
                        self.povodny = vrchol
                        vrchol.active()

    def udalost_tahanie(self, event):
        if self.active is not None:
            for r, s in self.active.sus:
                if (self.cesta and self.board[r][s] is self.cesta[-1]) or (self.board[r][s] not in self.cesta and self.board[r][s].volny and self.pocet_tahov < self.max and (type(self.active) is not Circle or self.active is self.povodny) and (type(self.board[r][s]) is Tile or (self.board[r][s].farba == "blue" and self.board[r][s].xy[1] != 695))):
                    x, y = self.board[r][s].xy
                    if ((x-event.x)**2 < R_druhu) and ((y-event.y)**2 < R_druhu):
                        if self.cesta and self.board[r][s] is self.cesta[-1]:
                            if type(self.active) is Circle:
                                self.active.kresli()
                            self.tah(-1)
                            self.cesta.pop()
                            self.c.delete(self.ciary.pop())
                            self.active = self.board[r][s] 
                        else:
                            self.tah(+1)
                            self.spojenie(self.active, self.board[r][s], "blue")
                            if type(self.active) is Circle:
                                self.active.active()
                            self.active = self.board[r][s]
                            if type(self.active) is Circle:
                                self.active.active()
                    
    def udalost_koniec(self, event):
        if self.active is not None:
            self.pocet_tahov = 0
            if type(self.active) is Circle and self.active != self.povodny :
                self.active.active()
                for vrchol in self.cesta:
                    vrchol.volny = 0
                self.active.volny = 0
                Circle.remain.remove(self.povodny)
                Circle.remain.remove(self.active)
                if not (self.oponent()):
                    self.c.unbind('<B1-Motion>')
                    self.c.unbind('<ButtonRelease-1>')
                    self.end("Victory")
                    self.stop = 1
            else:
                for ciara in self.ciary:
                    self.c.delete(ciara)
                self.tah(0)
                self.povodny.kresli()
            self.cesta = []
            self.ciary = []
            self.active = None

    def oponent(self): 
        def backtracking(v1, cesta):
            if self.cesta:
                return
            if type(v1) == Circle and v1 not in self.oponentove:
                self.cesta = cesta
            else:
                self.visited.add(v1)
                for r, s in v1.sus:
                    v = self.board[r][s]
                    if (v not in self.visited and len(cesta)<=self.max and v.volny) and ((type(v) is Tile) or (v.farba == "red" and v not in self.oponentove)):
                        backtracking(v, cesta+[v])
                self.visited.remove(v1)                   

        self.cesta = []
        for v1 in self.oponentove:
            if self.cesta:
                break
            self.visited = set()
            backtracking(v1, [v1])

        if not self.cesta:
            return False
        else:
            self.oponentove.remove(self.cesta[0])
            for i in range(len(self.cesta)-1):
                self.cesta[i].volny = 0
                self.cesta[i+1].volny = 0
                self.c.create_line(self.cesta[i].xy, self.cesta[i+1].xy, fill="red", width=10)
                if type(self.cesta[i]) == Circle:
                    self.cesta[i].active()
                if type(self.cesta[i+1]) == Circle:
                    self.cesta[i+1].active()
                self.c.update()
                self.c.after(200)
            self.max += 2
            self.tah(0)
            return True

    def surrender(self):
        if not self.stop:
            self.c.unbind('<B1-Motion>')
            self.c.unbind('<ButtonRelease-1>')
            self.stop = 1
            if (self.oponent()):
                self.end("Defeat")
            else:
                self.end("Draw")

    def end(self, stav):
        if stav == "Victory":
            farba = "green"
        elif stav == "Defeat":
            farba = "red"
        else:
            farba = "blue"
        self.table = tkinter.PhotoImage(file='files/table.gif')
        self.c.create_image(380, 380, image=self.table)
        self.c.create_text(380, 360, text=stav, fill=farba, font = "arial 35 bold")
        self.c.create_text(380, 410, text="No. Connections: " + str((10 - len(Circle.remain)) // 2), fill="grey", font = "arial 20 bold") 

##################################################################################################################################

class Single:
    def __init__(self):
        self.c.delete("all")
        Circle.remain = set()
        self.bg = tkinter.PhotoImage(file='files/bg.gif')
        self.c.create_image(0, 0, image=self.bg, anchor='nw')

        self.tlacidla = set()
        self.tlacidla.add(Button(915,695,"Back to Menu", Menu))
        self.tlacidla.add(Button(915,555,"Reset Level", Single))
        for tlacidlo in self.tlacidla:
            tlacidlo.normal()

        self.pocet_tahov = 0
        self.img = tkinter.PhotoImage(file='files/btn_hover.gif')
        self.c.create_image(915, 415, image=self.img)
        self.tahy_vypis = self.c.create_text(915, 415, text="Moves: " + str(self.pocet_tahov), fill="black", font = "arial 35 bold") 

        self.board = [[] for i in range(10)]
        for i in range(10):
            for j in range(10):
                self.board[i].append(Tile(70*j+65, 70*i+65))
                if i > 0:
                    self.board[i][j].sus.add((i-1,j))
                    self.board[i-1][j].sus.add((i, j))
                if j > 0:
                    self.board[i][j].sus.add((i, j-1))
                    self.board[i][j-1].sus.add((i, j))

        self.nacitaj_level()
        
        for riadok in self.board:
            for vrchol in riadok:
                vrchol.kresli()

        self.active = None
        self.ciary = []
        self.cesta = []
        self.time = time()
        self.c.bind('<Button-1>', self.udalost_klik)
        self.c.bind('<B1-Motion>', self.udalost_tahanie)
        self.c.bind('<ButtonRelease-1>', self.udalost_koniec)
        self.c.bind('<Motion>', self.udalost_pohyb)
        

    def nacitaj_level(self):
        with open ("levels/level" + str(Hra.level) + ".txt") as level:
            for riadok in level:
                pole = riadok.strip().split()
                if len(pole) == 5:
                    self.board[int(pole[0])][int(pole[1])] = Circle(self.board[int(pole[0])][int(pole[1])], self.board, pole[4])
                    self.board[int(pole[2])][int(pole[3])] = Circle(self.board[int(pole[2])][int(pole[3])], self.board, pole[4])
                else:
                    for i in range(0, len(pole), 2):
                        self.board[int(pole[i])][int(pole[i+1])] = Obstacle(self.board[int(pole[i])][int(pole[i+1])], self.board)

    def tah(self):
        self.pocet_tahov += 1
        self.c.itemconfig(self.tahy_vypis, text="Moves: " + str(self.pocet_tahov))

    def spojenie(self, v1, v2, farba):
        self.cesta.append(v1)
        self.ciary.append(self.c.create_line(v1.xy, v2.xy, fill=farba, width=10))

    def udalost_pohyb(self, event):
        for tlacidlo in self.tlacidla:
            x, y = tlacidlo.xy
            if ((x-event.x)**2 < tlac_sirka) and ((y-event.y)**2 < tlac_vyska):
                tlacidlo.hover()
            else:
                tlacidlo.normal()

    def udalost_klik(self, event):
        for tlacidlo in self.tlacidla:
            x, y = tlacidlo.xy
            if ((x-event.x)**2 < tlac_sirka) and ((y-event.y)**2 < tlac_vyska):
                tlacidlo.active()
        for riadok in self.board:
            for vrchol in riadok:
                if type(vrchol) == Circle and vrchol.volny:
                    x, y = vrchol.xy
                    if ((x-event.x)**2 < R_druhu) and ((y-event.y)**2 < R_druhu):
                        self.active = vrchol
                        self.povodny = vrchol
                        vrchol.active()

    def udalost_tahanie(self, event):
        if self.active is not None:
            for r, s in self.active.sus:
                if (self.cesta and self.board[r][s] is self.cesta[-1]) or (self.board[r][s] not in self.cesta and self.board[r][s].volny and (type(self.active) is not Circle or self.active is self.povodny) and (type(self.board[r][s]) is Tile or (self.board[r][s].farba == self.povodny.farba))):
                    x, y = self.board[r][s].xy
                    if ((x-event.x)**2 < R_druhu) and ((y-event.y)**2 < R_druhu):
                        self.tah()
                        if self.cesta and self.board[r][s] == self.cesta[-1]:
                            if type(self.active) is Circle:
                                self.active.kresli()
                            self.cesta.pop()
                            self.c.delete(self.ciary.pop())
                            self.active = self.board[r][s]   
                        else: 
                            self.spojenie(self.active, self.board[r][s], self.povodny.farba)
                            if type(self.active) is Circle:
                                self.active.active()
                            self.active = self.board[r][s]
                            if type(self.active) is Circle:
                                self.active.active()
                    
    def udalost_koniec(self, event):
        if self.active is not None:
            if type(self.active) is Circle and self.active != self.povodny:
                self.active.active()
                for vrchol in self.cesta:
                    vrchol.volny = 0
                self.active.volny = 0
                Circle.remain.remove(self.povodny)
                Circle.remain.remove(self.active)
                if len(Circle.remain) == 0:
                    self.end()
            else:
                for ciara in self.ciary:
                    self.c.delete(ciara)
                self.povodny.kresli()
            self.active = None
            self.ciary = []
            self.cesta = []

    def dalsi_level(self):
        Hra.level += 1
        if Hra.level > 4:
            Hra.level = 1
        Single()

    def end(self):
        with open("stats/level" + str(Hra.level) + ".txt", "w") as stats:
            print("Moves: " + str(self.pocet_tahov), file=stats)
            print("Time: " + "{:02}:{:02}".format(int((time()-self.time)//60), int((time()-self.time)%60)), file=stats)
        self.c.unbind('<B1-Motion>')
        self.c.unbind('<ButtonRelease-1>')
        self.table = tkinter.PhotoImage(file='files/table_sp.gif')
        self.c.create_image(380, 345, image=self.table)
        self.c.create_text(380, 280, text="Level Complete!", fill="green", font = "arial 35 bold")
        self.c.create_text(380, 325, text="Moves: " + str(self.pocet_tahov), fill="grey", font = "arial 20 bold")
        self.c.create_text(380, 355, text="Time: " + "{:02}:{:02}".format(int((time()-self.time)//60), int((time()-self.time)%60)), fill="grey", font = "arial 20 bold")
        tlacidlo = Button(380,415,"Next Level", self.dalsi_level)
        self.tlacidla.add(tlacidlo)
        tlacidlo.normal()

circles = Hra()




